// C Source File
// Created 12/2/00; 9:22:13 AM

#include "Rip.h"
int argcount=1;

void _main(void)
{
	ESI argptr;					
	unsigned long FileLen;//Length of the variable
	int i;							 //counter var
	SYM_ENTRY *WorkSym;	//SYM_ENTRY for the variable
	char filestr[19];		//17 byte file name 2 byte zero term
	char auxbuffer[9]; // random file name buffer 0 name len
	char *szFile;				//aux var usually points to the File\0 name
	char *TIOSFile;			//aux var usually points to  the TIOS varable name filestr
	char *pauxbuffer;		//Pointer for auxbuffer
	unsigned char *CharPtr;	//pointer for the current pos in file on the heap
	const char FileTag[8]={VersionTag,0,'S','N','A','P',0,0xF8}; //tag & file type
	
	InitArgPtr(argptr);  
	if (GetArgType(argptr) != STR_TAG)
	{
		DispMessage("Type: rip(\"var\")");
		return;	
	}
	
//number of args passed if !0 then silent mode
	argcount=ArgCount();
	
//convert the passed file name szFile to tios format in filestr
	filestr[0]=0;
	(const char*)szFile=GetStrnArg(argptr);
	TIOSFile=strcpy(filestr + 1, szFile) + strlen(szFile);
	
//See if it exists
	WorkSym=DerefSym(SymFind(TIOSFile));
	
//update the current list kept by the TI-OS
	MO_currentOptions();
	
//now either do or take a snapshot of the current settings
		if(!WorkSym)	//if the file exists then restore else take snapshot
			{		//****TAKE SNAPSHOT****//
				if(AskMessage("Take Snapshot?")==KEY_ENTER)
				{
					//Store the GDB
						TRY
							cmd_stogdb(TIOSFile);
						ONERR
							ER_success();		//clear the error frame
							ErrorExit();		//inform the user of abnormal termination
							return;
						ENDTRY
				
				//Add on to the new GDB var
						
						//Find the new GDB var
							WorkSym=DerefSym(SymFind(TIOSFile));
							
						//lock it and get a pointer to the mem
							if(!(CharPtr=HLock(WorkSym->handle)))
								{
									ErrorExit();
									SymDel(TIOSFile);
									return;
								}

						//resize the file to the correct length
						//           APD is:  4 bytes
						// *ModeSettings is: 40 bytes (room for 20 options)
						//current folder is:  9 bytes
						// File version  is: 	1 byte
						// File type tag is:  7 bytes
						//   grand total is: 59 bytes
							FileLen=*(int*)CharPtr+2;
							if((WorkSym->handle=HeapRealloc(
								  WorkSym->handle,FileLen+61))==H_NULL)
									{
										ErrorExit();
										SymDel(TIOSFile);
										return;
									}

					//update the var size
						*(int*)CharPtr=FileLen+57;//59-2 cause i added 2 before...

					//update the pointer also
						CharPtr+=FileLen+59;
						
				//Save current Folder
				//REUSING filestr!!!!!!!
					FolderGetCur(filestr);
					memcpy(CharPtr-59,(char*)filestr,9);

				//Save current mode settings (some are redundant)
					memcpy(CharPtr-50,ModeSettings,38);

				//Save the APD
					OSTimerRestart(APD_TIMER);
					FileLen=OSTimerCurVal(APD_TIMER);
					memcpy(CharPtr-12,&FileLen,4);
					
				//Version Tag + var type
					memcpy(CharPtr-8,(char*)FileTag,8);

				//Unlock the Symbol
					HeapUnlock(WorkSym->handle);
					
    		//We're outa here!
					DispMessage("Done!");
				}
		}
		else
		{		//*****RESTORE SNAPSHOT*****//	
				
				//Get the pointer and file size
				CharPtr=HeapDeref(WorkSym->handle);
				FileLen=*(int*)CharPtr+2;
				
				//Make sure we have the correct file type
			   if(strcmp(CharPtr+FileLen-6,(char*)FileTag+2) || 
			   	*(CharPtr+FileLen-8)!=VersionTag)
					{
						DispMessage("Bad Snapshot!");
						return;
					}
		//Ask to restore the snap shot
			if(AskMessage("Restore Snapshot?")==KEY_ENTER)
			{//****DO THE RESTORE****//
				
	    		
	    //set up the zero start/term format for TIOS var name		
				auxbuffer[0]=0;	//0 start
				auxbuffer[9]=0;//0 term
				pauxbuffer=auxbuffer+9;
			//pick a random file name until one that does not exist is found
				do	//i couldn't get HS_NULL to work here in the while
				{
					for(i=1;i<9;i++)
						auxbuffer[i]=((rand()%25)+97);	//97 - 122 = a - y  odd25 makes z impossible
				}
				while(SymFind(auxbuffer).offset);

			//Shouldn't cause an error since filestr does not exist		
				cmd_copyvar(TIOSFile,pauxbuffer);

			//Restore the gdb	
				CharPtr=HeapDeref(DerefSym(SymFind(pauxbuffer))->handle);
				*(int*)CharPtr-=59;	//fool tios into thinking its a gdb
				cmd_rclgdb(pauxbuffer);
//	    	*(int*)CharPtr+=59; don't need to do this (trust me)

				CharPtr+=FileLen;	//the pointer points to the end of the file now

	    //restore the APD		REUSING FileLen!!!
	    	OSFreeTimer(APD_TIMER);
	    	memcpy(&FileLen,CharPtr-12,4);
	    	OSRegisterTimer(APD_TIMER,FileLen);
	    	
			//Restore mode settings
				memcpy(ModeSettings,CharPtr-50,38);
				MO_digestOptions(0);

			//restore the old folder	REUSING filestr,szFile!!!
			//it seems that i can get away with this...
				memcpy(szFile,CharPtr-59,9);
				filestr[0]=0;
				
			//Restore The Folder... Killing TIOSFile again
				TIOSFile=strcpy(filestr + 1, szFile) + strlen(szFile);
 		   	FolderAdd(TIOSFile);
 		   
 		   //Delete temporary variable before changing folder
	    	SymDel(pauxbuffer);

	    //set new current folder
 		   	FolderCur(TIOSFile,FALSE);
 		   	ST_folder(szFile);	
	    	
			//We're Done!!
				DispMessage("Done!");
				}
		}
		
//the end of _main		
}

////////////////////////////////
// Displays an Error Message //
// Prior to exiting in Error//
/////////////////////////////
void ErrorExit(void)
{
	if(argcount==1)
		DispMessage("Error!");
}

////////////////////////////////
//Displays a Message in a 	 //
//Dialog box                //
/////////////////////////////
void DispMessage(char *Message)
{
	if(argcount==1)
		DlgMessage(AppTitle AppVersion,Message,BT_OK,BT_NONE);
}

////////////////////////////////
//Displays a DlgMessage box  //
//returns DlgMessage			  //
/////////////////////////////
int AskMessage(char *Message)
{
	if(argcount==1)
		return DlgMessage(AppTitle AppVersion,Message,BT_YES,BT_NO);
	else
		return KEY_ENTER;
}
