;===============================================
;       TI-86 Text Viewer by Clem Vasseur
;           Email:darkclem@wanadoo.fr
; Icarus Productions - http://icarus.ticalc.org
;===============================================
; Last modified: August 03, 1999
;-----------------------------------------------
; May those who rip extensive amounts for
; exclusive personal gain be tormented
; accordingly by a guilty conscience.
;                            - Dan Eble -
;===============================================

#include "TI86.inc"

.org _asm_exec_ram

 nop
 jp ProgStart
 .dw 2,ShellTitle
 .dw 0
 .dw datatypes

ShellTitle:
 .text "Text Viewer"

datatypes:
 .db 1
 .dw text_dt


text_dt:
 .db 1							;high priority
 .db $12						;detects programs
 .db "txt"						;3 byte descripiton

 .dw Exec

 .dw detect_end-detect
 .dw detect-$-1

 .dw comment_end-comment
 .dw comment-$-1

 .dw icon_end-icon
 .dw icon-$-1

detect:
 call _get_data_size_de_inc
 call _inc_ptr_ahl
 call _get_data_size_de_inc
 ld hl,':'*256+'T'
 call _cphlde
 ret z
 scf
 ret
detect_end:

comment:
 ld de,$f500
 inc hl
 inc hl
writecomment:
 bit 6,h
 jr z,samepage
 res 6,h
 in a,(6)
 inc a
 out (6),a
samepage:
 ld a,(hl)
 sub $d6
 ldi
 jr nz,writecomment
 dec de
 ld (de),a
 ld hl,$f501
 ret
comment_end:

icon:
 ld hl,default_icon-icon+$f400
 ld bc,6+(1*256)
 or a
 ret

default_icon:
 .db %11100000
 .db %10111100
 .db %10010110
 .db %10010010
 .db %11110010
 .db %00011110
icon_end:

Exec:
 call _OP1TOOP6
 set ex_asm_module,(iy+anumeditFlgs)

ProgStart:
 ld a,1
 ld (WriteFlag),a
 call _runIndicOff
 call _flushAllMenus

 call _OP6TOOP1
 bit ex_asm_module,(iy+anumeditflgs)
 jp nz,VarLoad

FileSelector:
 call _clrWindow
 ld hl,TitleText
 call DispTextScreen

 ld hl,$12
 ld (_OP1),hl
 call NextFile
 jr nc,FileSelect

NoTextFile:
 ld hl,$0404
 ld (_curRow),hl
 ld hl,NoFileStr
 call _puts
 call GetKey
 jp _clrWindow

FileSelect:
 ld a,$17
 ld (_penRow),a
 ld hl,FileSelectStr
 call DispTextLine

DispFile:
 ld hl,$FEB0
 ld de,$FEB1
 ld bc,16*5-1
 ld (hl),0
 ldir
 ld a,$2A
 ld (_penRow),a
 ld hl,TxtDescription
 call DispTextLine

 ld hl,$0504
 ld (_curRow),hl
 ld a,' '
 ld b,10
ClrFileName:
 call _putc
 djnz ClrFileName
 ld hl,_OP1+1
 ld a,19
 sub (hl)
 and %11111110
 rrca
 ld (_curCol),a
 ld a,Lleft
 call _putc
 call _putps
 ld a,Lconvert
 call _putc

KeyLoopFile:
 call GetKey
 cp K_EXIT
 jp z,Exit
 cp K_RIGHT
 jr nz,SkipRight
 call NextFile
 jr DispFile
SkipRight:
 cp K_LEFT
 jr nz,SkipLeft
 call PrevFile
 jr DispFile
SkipLeft:
 cp K_ENTER
 jr nz,KeyLoopFile

VarLoad:
 res ex_asm_module,(iy+anumeditflgs)
 rst rfindsym
 call _DATA_SIZE_TO_DE
 ld (TextSize),de
 call SkipDescription
 ld hl,0
TextSize = $-2
 inc hl
 ld de,15*1024
 call _cphlde
 jr c,VarSizeOk
 ex de,hl
VarSizeOk:
 xor a
 call _SET_MM_NUM_BYTES
 inc a
 ld hl,$FF
 call _SET_ABS_DEST_ADDR
 call _mm_lDIR

 call _RAM_PAGE_1
 ld hl,(_ABS_DEST_ADDR+1)
 set 7,h
 xor a
 ld (hl),a
 ld (_altsfontptr),a

RedrawStart:
 ld hl,$8100
Redraw:
 push hl
 call _clrLCD
 pop hl
 ld (StartLinePtr),hl
 call DispTextScreen
 ld (EndLinePtr),hl

KeyLoop:
 halt\ halt\ halt
 ld a,$7E
 out (1),a
 nop\ nop
 nop\ nop
 in a,(1)
 rra
 jr nc,ScrollDown
 bit 2,a
 jr z,ScrollUp
 ld a,$FF
 out (1),a
 call _getcsc
 or a
 jr z,KeyLoop
 cp K_PLUS
 ld bc,$1F01
 jr z,ChangeContrast
 cp K_MINUS
 ld bc,$00FF
 jr z,ChangeContrast
 ld b,9
 cp K_F2
 jr z,PageUp
 cp K_F1
 jr z,PageDown
 cp K_ALPHA
 jr z,TurnOff
 cp K_SECOND
 jr z,RedrawStart
 cp K_CLEAR
 jp z,FileSelector
 cp K_MORE
 call z,NextBookmark
 cp K_EXIT
 jr nz,KeyLoop

Exit:
 res 4,(iy+9)
 jp _clrWindow

ChangeContrast:
 ld a,(_contrast)
 cp b
 jr z,KeyLoop
 add a,c
 ld (_contrast),a
 out (2),a
JR_KeyLoop:
 jr KeyLoop

ScrollDown:
 call ScrollTextDown
 jr KeyLoop
ScrollUp:
 call ScrollTextUp
 jr KeyLoop

PageDown:
 push bc
 call ScrollTextDown
 pop bc
 djnz PageDown
 jr KeyLoop
PageUp:
 push bc
 call ScrollTextUp
 pop bc
 djnz PageUp
 jr KeyLoop

TurnOff:
 ld a,1
 out (3),a
 halt
 ld a,11
 out (3),a
 jr JR_KeyLoop

DispTextScreen:
 xor a
DispScreenLoop:
 ld (_penRow),a
 call DispTextLine
 or a
 ret z
 ld a,(_penRow)
 add a,7
 cp 63
 jr nz,DispScreenLoop
 ret

DispTextLine:
 xor a
DispTextLineSetCol:
 ld (_penCol),a
 res 3,(iy+5)
 ld a,$37
 ld (StrikeFlag),a
 ld (UnderlineFlag),a
 xor a
 ld (BoldFlag),a
 ld (ItalicFlag),a
DispLineLoop:
 ld a,(hl)
 ld (EndFlag),a
 inc hl
 or a
 ret z
 cp $D6
 ret z
 cp ' '
 jr nz,SkipSpace
 ld a,(_penCol)
 ld (LastCol),a
 ld (LastPtr),hl
 ld a,' '
SkipSpace:
 cp '#'
 jr z,SpecialCmd
 cp 178	;''
 jr z,DispLineLoop
 cp	'~'
 call z,SpecialChar
DispChar:
 call PutChar
 call nc,WordWrap
 jr DispLineLoop

WordWrap:
 ld a,0
LastCol = $-1
 push af
 ld (_penCol),a
 set 1,(iy+5)
ClearLoop:
 ld c,' '
 call vPutmap
 jr c,ClearLoop
 res 1,(iy+5)
 pop af
 ld (_penCol),a
 ld hl,0
LastPtr = $-2
 dec hl
 ld (hl),$D6
 ret

SpecialCmd:
 ld de,DispLineLoop
 push de
 ld a,(hl)
 inc hl
 cp 'B'
 jr z,CmdBold
 cp 'C'
 jr z,CmdCenter
 cp 'D'
 jr z,CmdDivider
 cp 'i'
 jr z,CmdInverse
 cp 'I'
 jr z,CmdItalic
 cp 'R'
 jr z,CmdRight
 cp 'S'
 jr z,CmdStrike
 cp 'T'
 jr z,CmdTabulation
 cp 'U'
 jr z,CmdUnderline
UnrecognizedCmd:
 pop af
 dec hl
 ld a,'#'
 jr DispChar

CmdTabulation:
 ld a,(_penCol)
 add a,8
 and %11111000
 ld (_penCol),a
 ret

CmdBold:
 ld a,(BoldFlag)
 xor 1
 ld (BoldFlag),a
 ld de,BoldFont
ChangeFont:
 ld (_altsfontptr+1),de
 ret

CmdItalic:
 ld a,(ItalicFlag)
 xor 1
 ld (ItalicFlag),a
 ld de,ItalicFont
 jr ChangeFont

CmdInverse:
 ld a,(iy+5)
 xor %00001000
 ld (iy+5),a
 ret

CmdStrike:
 ld a,(StrikeFlag)
 xor 128
 ld (StrikeFlag),a
 ret

CmdUnderline:
 ld a,(UnderlineFlag)
 xor 128
 ld (UnderlineFlag),a
 ret

CmdCenter:
 ld a,(WriteFlag)
 or a
 ret z
 call Justify
 sra a
 pop bc
 jp DispTextLineSetCol

CmdRight:
 ld a,(WriteFlag)
 or a
 ret z
 call Justify
 pop bc
 jp DispTextLineSetCol

CmdDivider:
 ld a,(hl)
 cp '8'
 jr nc,UnrecognizedCmd
 sub '0'
 jr c,UnrecognizedCmd
 inc hl

 push hl
 add a,a
 ld d,a
 add a,a
 add a,a
 ld b,a
 ld a,16
 sub d
 push af
 ld a,(_penRow)
 add a,3
 ld c,a
 call PixelOn
 pop bc
DividerLoop:
 ld (hl),$FF
 inc l
 djnz DividerLoop
 pop hl
 ret

Justify:
 xor a
 ld (WriteFlag),a
 push hl
 call DispTextLine
 ld hl,_penCol
 ld a,127
 ld (WriteFlag),a
 sub (hl)
 pop hl
 ret

SpecialChar:
 ld (PtrSave),hl
 xor a
 ld d,3
GetNumLoop:
 ld b,a
 ld a,(hl)
 cp '9'+1
 jr nc,GetNumEnd
 sub '0'
 jr c,GetNumEnd
 ld c,a
 ld a,b
 add a,a
 add a,a
 add a,b
 add a,a
 add a,c
 inc hl
 dec d
 jr nz,GetNumLoop
 ld b,a
GetNumEnd:
 ld a,b
 or a
 jr z,InvalidChar
 cp 231
 ret c
InvalidChar:
 ld hl,0
PtrSave = $-2
 ld a,'~'
 ret

PutChar:
 ld c,a
 ld a,0
BoldFlag = $-1
 add a,0
ItalicFlag = $-1
 jr z,vPutmap
 dec a
 jr z,EnableFont
 ld de,BoldItalicFont
 ld (_altsfontptr+1),de
EnableFont:
 set 1,(iy+$23)
vPutmap:
 push hl
 ld a,(_penCol)
 ld (ColSave),a
 push af
 ld a,(WriteFlag)
 or a
 ld a,c
 push bc
 call z,vputmapNoWrite
 call nz,_vputmap
 pop bc
UnderlineFlag:
 scf
 call nc,Underline
StrikeFlag:
 scf
 call nc,Strike
 res 1,(iy+$23)
 pop bc
 pop hl
 ld a,(_penCol)
 cp b
 ret z
 scf
 ret

vputmapNoWrite:
 push af
 call _copycharmaps
 ld a,(_penCol)
 add a,(hl)
 cp 127
 jr nc,skip
 ld (_penCol),a
skip:
 pop af
 ret

Strike:
 ld a,3
 ld (LinePos),a
 jr DrawLine

Underline:
 ld a,6
 ld (LinePos),a

DrawLine:
 ld a,c
 call _copycharmaps
 ld b,0
ColSave = $-1
 ld a,(_penRow)
 add a,0
LinePos = $-1
 ld c,a
 ld a,(_charmap)
LineLoop:
 push af
 call PixelOn
 inc b
 pop af
 dec a
 jr nz,LineLoop
 ret

PixelOn:
 ld a,0
WriteFlag = $-1
 or a
 ret z
 ld a,b
 cp 127
 ret nc
 ld h,63
 ld a,c
 add a,a
 add a,a
 ld l,a
 ld a,b
 rra
 add hl,hl
 rra
 add hl,hl
 rra
 or l
 ld l,a
 ld a,b
 and 7
 cpl
 rlca
 rlca
 rlca
 ld (PixBit+1),a
 xor a
PixBit:
 set 0,a
 or (hl)
 ld (hl),a
 ret

NextBookmark:
 ld hl,(StartLinePtr)
SearchLoop:
 inc hl
 ld a,(hl)
 or a
 ret z
 cp 178	;''
 jr nz,SearchLoop
 dec hl
 ld a,(hl)
 cp $D6
 inc hl
 jr nz,SearchLoop
NextBookmarkLoop:
 call ScrollTextDown
 ret nc
 ld hl,(StartLinePtr)
 ld a,(hl)
 cp 178	;''
 jr nz,NextBookmarkLoop
 ret

ScrollTextDown:
 ld a,0
EndFlag = $-1
 or a
 ret z

 ld hl,$FC00+(7*16)
 ld de,$FC00
 ld bc,1024-(7*16)
 ldir
 ld hl,-(7*16)
 ld de,-(7*16)+1
 ld c,(7*16)-1
 ld (hl),b
 ldir

 ld a,$D6
 ld hl,(StartLinePtr)
 cpir
 ld (StartLinePtr),hl

 ld a,$38
 ld (_penRow),a
 ld hl,0
EndLinePtr = $-2
 call DispTextLine
 ld (EndLinePtr),hl
 scf
 ret

ScrollTextUp:
 ld hl,$8100
StartLinePtr = $-2
 ld de,$8100
 call _cphlde
 ret z

 ld hl,$FFFF-(7*16)
 ld de,$FFFF
 ld bc,1024-(7*16)
 lddr
 ld hl,$FC00
 ld de,$FC01
 ld c,(7*16)-1
 ld (hl),b
 ldir
 ld hl,$FFF0
 ld de,$FFF1
 ld c,15
 ld (hl),b
 ldir

 ld a,$D6
 ld hl,(EndLinePtr)
 dec hl
 dec hl
 cpdr
 inc hl
 inc hl
 ld (EndLinePtr),hl

 ld hl,(StartLinePtr)
 dec hl
 dec hl
 cpdr
 inc hl
 inc hl
 ld (StartLinePtr),hl

 xor a
 ld (_penRow),a
 jp DispTextLine

GetKey:
 halt
 call _getcsc
 or a
 jr z,GetKey
 ret

PrevFile:
 ld a,_findalphaDn & $FF
 jr SearchFileModif
NextFile:
 ld a,_FINDALPHAUP & $FF
SearchFileModif:
 ld (SFModif),a
 ld (FileFlag),a
 call SearchFile
 ret nc
 ld a,0
FileFlag = $-1
 or a
 jr z,InvSearch
 scf
 ret
InvSearch:
 ld a,(SFModif)
 xor 4
 ld (SFModif),a
SearchFile:
 xor a
 call _FINDALPHAUP
SFModif = $-2
 ret c
 rst rfindsym
 call _DATA_SIZE_TO_DE
 call _GET_DATA_SIZE_DE_INC
 push de
 call _GET_DATA_SIZE_DE_INC
 pop bc
 push af
 ld a,e
 cp ':'
 jr nz,InvalidFile
 ld a,b
 cp 'T'
 jr nz,InvalidFile
 ld a,c
 or a
 jr z,GetDescription
InvalidFile:
 pop af
 xor a
 ld (FileFlag),a
 jr SearchFile

GetDescription:
 pop af
 call _dec_ptr_ahl
SkipDescription:
 ld bc,TxtDesc
GetDescLoop:
 push af
 push bc
 push hl
 call _GETB_AHL
 ld hl,(TextSize)
 dec hl
 ld (TextSize),hl
 pop hl
 pop bc
 ld (bc),a
 inc bc
 cp $D6
 jr z,GetDescExit
 pop af
 call _INC_PTR_AHL
 call _SET_ABS_SRC_ADDR
 jr GetDescLoop
GetDescExit:
 pop af
 or a
 ret

TitleText:
 .db "#i#U #BT#Bext #BV#Biewer by #BC#Blem #BV#Basseur --- v1.1",$D6
 .db "Icarus Productions  -  icarus.ticalc.org",$D6
 .db "#D0",$D6,$D6,$D6,$D6,$D6
 .db "#D0",$D6
 .db "#C#BCOPYRIGHT (C)2001 by CLEM",$D6

NoFileStr:
 .text "No text found",0

FileSelectStr:
 .db "#CSelect a text file",$D6

#INCLUDE "FNT_Bold.inc"
#INCLUDE "FNT_Italic.inc"
#INCLUDE "FNT_Bold_Italic.inc"

TxtDescription:
 .db "#C"
TxtDesc:

.end
